/*
THIS SOFTWARE IS PROVIDED BY ANALOG DEVICES INC. ``AS IS'' AND ANY EXPRESS OR
IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR NON-INFRINGEMENT, ARE
DISCLAIMED. IN NO EVENT SHALL ANALOG DEVICES INC. BE LIABLE FOR ANY DIRECT,
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
POSSIBILITY OF SUCH DAMAGE.

YOU ASSUME ANY AND ALL RISK FROM THE USE OF THIS CODE OR SUPPORT FILE.

IT IS THE RESPONSIBILITY OF THE PERSON INTEGRATING THIS CODE INTO AN APPLICATION
TO ENSURE THAT THE RESULTING APPLICATION PERFORMS AS REQUIRED AND IS SAFE.

    Module       : util.c
    Description  : Utility functions
    Date         : 10 June 2010
    Version      : v1.00
    Changelog    : v1.00 Initial

*/
#include <include.h>

//*****************************************************************************
// Function    : ExtInt_Enable
// Description : Enable the specified external interrupt
//*****************************************************************************
void ExtInt_Enable(unsigned int iExtIntNum)
{
   volatile unsigned long      * pINTSETEx;
   unsigned long                INTSETEx_A;

   // Determine the address of the correct interrupt register
   INTSETEx_A = ISER0_A + ((iExtIntNum/NUM_BITS_IN_ULONG)*NUM_CHAR_IN_ULONG);
   pINTSETEx  = (volatile unsigned long *)INTSETEx_A;

   // Set the appropriate bit in
   *pINTSETEx = 0x1UL << (iExtIntNum % NUM_BITS_IN_ULONG);
}
//*****************************************************************************
// Function    : ExtInt_Disable
// Description : Disable the specified external interrupt
//*****************************************************************************
void ExtInt_Disable(unsigned int iExtIntNum)
{
   volatile unsigned long      * pINTCLREx;
   unsigned long                INTCLREx_A;

   // Determine the address of the correct interrupt register
   INTCLREx_A = ICER0_A + ((iExtIntNum/NUM_BITS_IN_ULONG)*NUM_CHAR_IN_ULONG);
   pINTCLREx  = (volatile unsigned long *)INTCLREx_A;

   // Set the appropriate bit in
   *pINTCLREx = 0x1UL << (iExtIntNum % NUM_BITS_IN_ULONG);
}

//*****************************************************************************
// Function    : ExtInt_SetPriority
// Description : Set the priority of the specified external interrupt
//*****************************************************************************
void ExtInt_SetPriority(unsigned int iExtIntNum,unsigned char Pri)
{
   // We will access the priority registers byte-wise which is allowed
   volatile unsigned char * pINTPRIx = (volatile unsigned char *)IPR0_A;

   * (pINTPRIx + iExtIntNum) = Pri;
}



